/**
* Script: event.js
* Written by: Radnen
* Updated: 8/20/2010
**/

/**
* .NET like event handler.
*  - this handler allows you to push functions onto a list and have it
*    for at any time from anywhere, while maintaining references to its
*    parent and caller objects.
**/
function Event(parent)
{
	this.parent = parent;
	this.queue = [];
	
	/**
	* execute();
	*  - executes all of the commands, with a reference back to its parent.
	**/
	this.execute = function() {
		Utility.foreach(this.queue, function(event, base) {
			event.func.apply(base.parent, [event.sender]);
		}, this);
	}
	
	/**
	* add(func [, sender]);
	*  - func: the function to be called.
	*  - sender: the object which contains the function, optional if global or anonymous.
	**/
	this.add = function(func, sender) {
		this.queue.push({func: func, sender: sender});
	}
}